CREATE SCHEMA AgencjaArtystycznaZmiana;

SET search_path TO AgencjaArtystycznaZmiana;

CREATE TABLE Agenci ( 
 IDAgenta SERIAL PRIMARY KEY, 
 ImieAgenta varchar (25) NULL , 
 NazwiskoAgenta varchar (25) NULL , 
 AdresAgenta varchar (50) NULL , 
 MiastoAgenta varchar (30) NULL , 
 StanZamAgenta varchar (2) NULL , 
 KodPocztowyAgenta varchar (10) NULL , 
 TelefonAgenta varchar (15) NULL , 
 DataZatrudnienia date NULL , 
 Wynagrodzenie decimal(15,2) NULL DEFAULT 0 , 
 Premia float(24) NULL DEFAULT 0 );

CREATE TABLE Klienci ( 
 IDKlienta SERIAL PRIMARY KEY, 
 ImieKlienta varchar (25) NULL , 
 NazwiskoKlienta varchar (25) NULL , 
 AdresKlienta varchar (50) NULL , 
 MiastoKlienta varchar (30) NULL , 
 StanZamKlienta varchar (2) NULL , 
 KodPocztowyKlienta varchar (10) NULL , 
 TelefonKlienta varchar (15) NULL );

CREATE TABLE Imprezy ( 
 NumerImprezy SERIAL PRIMARY KEY, 
 DzienRozpoczecia date NULL , 
 DzienZakonczenia date NULL , 
 GodzinaRozpoczecia time NULL ,  
 GodzinaZakonczenia time NULL , 
 WartoscKontraktu decimal(15,2) NULL DEFAULT 0 , 
 IDKlienta int NULL DEFAULT 0 , 
 IDAgenta int NULL DEFAULT 0 , 
 IDWykonawcy int NULL DEFAULT 0 );

CREATE TABLE Imprezy_archiwum ( 
 NumerImprezy int NOT NULL PRIMARY KEY , 
 DzienRozpoczecia date NULL , DzienZakonczenia date NULL , 
 GodzinaRozpoczecia time NULL , GodzinaZakonczenia time NULL , 
 WartoscKontraktu decimal(15,2) NULL , 
 IDKlienta int NULL , 
 IDAgenta int NULL , 
 IDWykonawcy int NULL );

CREATE TABLE Czlonkowie_zespolu ( 
 IDWykonawcy int NOT NULL , 
 IDCzlonka int NOT NULL DEFAULT 0 , 
 Status smallint NULL DEFAULT 0 );

CREATE TABLE Style_wykonawcow ( 
 IDWykonawcy int NOT NULL , 
 IDStylu int NOT NULL DEFAULT 0 );

CREATE TABLE Wykonawcy ( 
 IDWykonawcy SERIAL PRIMARY KEY, 
 NazwaScenicznaWykonawcy varchar (50) NULL , 
 NrUbezpWykonawcy varchar (12) NULL , 
 AdresWykonawcy varchar (50) NULL , 
 MiastoWykonawcy varchar (30) NULL , 
 StanZamWykonawcy varchar (2) NULL , 
 KodPocztowyWykonawcy varchar (10) NULL , 
 TelefonWykonawcy varchar (15) NULL , 
 StronaInterWykonawcy varchar (50) NULL , 
 EmailWykonawcy varchar (50) NULL , 
 DataRejestracji date NULL , 
 StawkaDziennaWykonawcy decimal(15,2) NULL );

CREATE TABLE Czlonkowie ( 
 IDCzlonka SERIAL PRIMARY KEY, 
 ImieCzlonka varchar (25) NULL , 
 NazwiskoCzlonka varchar (25) NULL , 
 TelefonCzlonka varchar (15) NULL , 
 Plec varchar (2) NULL );

CREATE TABLE Gusty_muzyczne ( 
 IDKlienta int NOT NULL DEFAULT 0 , 
 IDStylu int NOT NULL DEFAULT 0 );

CREATE TABLE Style_muzyczne ( 
 IDStylu SERIAL PRIMARY KEY, 
 NazwaStylu varchar (75) NULL );

CREATE INDEX KodPocztowyAgenta ON Agenci(KodPocztowyAgenta);

CREATE INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta);

CREATE INDEX AgenciImprezy ON Imprezy(IDAgenta);

CREATE INDEX IDKlienta ON Imprezy(IDKlienta);

CREATE INDEX IDPracownika ON Imprezy(IDAgenta);

CREATE INDEX IDWykonawcy ON Imprezy(IDWykonawcy);

CREATE INDEX EnA_IDKlienta ON Imprezy_archiwum(IDKlienta);

CREATE INDEX EnA_IDPracownika ON Imprezy_archiwum(IDAgenta);

CREATE INDEX EnA_IDWykonawcy ON Imprezy_archiwum(IDWykonawcy);

ALTER TABLE Czlonkowie_zespolu 
 ADD CONSTRAINT Czlonkowie_zespolu_PK PRIMARY KEY 
 ( 
 IDWykonawcy, 
 IDCzlonka 
 );

CREATE INDEX WykonawcyCzlonkowie_zespolu ON Czlonkowie_zespolu(IDWykonawcy);

CREATE INDEX CzlonkowieCzlonkowie_zespolu ON Czlonkowie_zespolu(IDCzlonka);

ALTER TABLE Style_wykonawcow 
 ADD CONSTRAINT Style_wykonawcow_PK PRIMARY KEY 
 ( 
 IDWykonawcy, 
 IDStylu 
 );

CREATE INDEX WykonawcyStyle_wykonawcow ON Style_wykonawcow(IDWykonawcy);

CREATE INDEX Style_muzyczneStyle_wykonawcow ON Style_wykonawcow(IDStylu);

CREATE INDEX KodPocztowyWykonawcy ON Wykonawcy(KodPocztowyWykonawcy);

ALTER TABLE Gusty_muzyczne 
 ADD CONSTRAINT Gusty_muzyczne_PK PRIMARY KEY 
 ( 
 IDKlienta, 
 IDStylu 
 );

CREATE INDEX MP_IDKlienta ON Gusty_muzyczne(IDKlienta);

CREATE INDEX IDStylu ON Gusty_muzyczne(IDStylu);

ALTER TABLE Imprezy 
 ADD CONSTRAINT Imprezy_FK00 FOREIGN KEY 
 ( 
 IDAgenta 
 ) REFERENCES Agenci ( 
 IDAgenta 
 ), 
 ADD CONSTRAINT Imprezy_FK01 FOREIGN KEY 
 ( 
 IDKlienta 
 ) REFERENCES Klienci ( 
 IDKlienta 
 ), 
 ADD CONSTRAINT Imprezy_FK02 FOREIGN KEY 
 ( 
 IDWykonawcy 
 ) REFERENCES Wykonawcy ( 
 IDWykonawcy 
 );

ALTER TABLE Czlonkowie_zespolu 
 ADD CONSTRAINT Czlonkowie_zespolu_FK00 FOREIGN KEY 
 ( 
 IDWykonawcy 
 ) REFERENCES Wykonawcy ( 
 IDWykonawcy 
 ), 
 ADD CONSTRAINT Czlonkowie_zespolu_FK01 FOREIGN KEY 
 ( 
 IDCzlonka 
 ) REFERENCES Czlonkowie ( 
 IDCzlonka 
 );

ALTER TABLE Style_wykonawcow 
 ADD CONSTRAINT Style_wykonawcow_FK00 FOREIGN KEY 
 ( 
 IDWykonawcy 
 ) REFERENCES Wykonawcy ( 
 IDWykonawcy 
 ), 
 ADD CONSTRAINT Style_wykonawcow_FK01 FOREIGN KEY 
 ( 
 IDStylu 
 ) REFERENCES Style_muzyczne 
 ( 
 IDStylu 
 );

ALTER TABLE Gusty_muzyczne 
 ADD CONSTRAINT Gusty_muzyczne_FK00 FOREIGN KEY 
 ( 
 IDKlienta 
 ) REFERENCES Klienci ( 
 IDKlienta 
 ), 
 ADD CONSTRAINT Gusty_muzyczne_FK01 FOREIGN KEY 
 ( 
 IDStylu 
 ) REFERENCES Style_muzyczne ( 
 IDStylu 
 );

